CREATE TABLE `tadnews_files_center` (
  `files_sn` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `col_name` varchar(255) NOT NULL default '',
  `col_sn` smallint(5) unsigned NOT NULL,
  `sort` smallint(5) unsigned NOT NULL,
  `kind` enum('img','file') NOT NULL,
  `file_name` varchar(255) NOT NULL default '',
  `file_type` varchar(255) NOT NULL default '',
  `file_size` int(10) unsigned NOT NULL,
  `description` text NOT NULL,
  `counter` mediumint(8) unsigned NOT NULL,
  PRIMARY KEY (`files_sn`)
) ENGINE=MyISAM;



CREATE TABLE `tad_news` (
  `nsn` smallint(5) unsigned NOT NULL auto_increment,
  `ncsn` smallint(5) unsigned NOT NULL,
  `news_title` varchar(255) NOT NULL default '',
  `news_content` text NOT NULL,
  `start_day` datetime NOT NULL default '0000-00-00 00:00:00',
  `end_day` datetime default NULL,
  `enable` enum('1','0') NOT NULL default '1',
  `uid` smallint(5) unsigned NOT NULL,
  `passwd` varchar(255) NOT NULL default '',
  `enable_group` varchar(255) NOT NULL default '',
  `counter` smallint(5) unsigned NOT NULL,
  `prefix_tag` varchar(255) NOT NULL default '',
  `always_top` enum('0','1') NOT NULL,
  `always_top_date` datetime NOT NULL default '0000-00-00 00:00:00',
  `have_read_group` varchar(255) NOT NULL default '',
  `page_sort` SMALLINT(5) UNSIGNED NOT NULL,
  PRIMARY KEY  (`nsn`)
) ENGINE=MyISAM;



CREATE TABLE `tad_news_cate` (
  `ncsn` smallint(5) unsigned NOT NULL auto_increment,
  `of_ncsn` smallint(5) unsigned NOT NULL,
  `nc_title` varchar(255) NOT NULL default '',
  `enable_group` varchar(255) NOT NULL default '',
  `enable_post_group` varchar(255) NOT NULL default '',
  `sort` smallint(5) unsigned NOT NULL,
  `cate_pic` varchar(255) NOT NULL default '',
  `not_news` enum('0','1') NOT NULL,
  `setup` TEXT NOT NULL,
  PRIMARY KEY  (`ncsn`)
) ENGINE=MyISAM;



CREATE TABLE `tad_news_paper` (
  `npsn` smallint(5) unsigned NOT NULL auto_increment,
  `nps_sn` mediumint(8) unsigned NOT NULL,
  `number` smallint(5) unsigned NOT NULL,
  `nsn_array` text NOT NULL,
  `np_content` text NOT NULL,
  `np_date` datetime NOT NULL,
  PRIMARY KEY  (`npsn`)
) ;


CREATE TABLE `tad_news_paper_email` (
  `nps_sn` smallint(6) NOT NULL,
  `email` varchar(255) NOT NULL default '',
  `order_date` datetime NOT NULL,
  PRIMARY KEY  (`nps_sn`,`email`)
) ENGINE=MyISAM;



CREATE TABLE `tad_news_paper_setup` (
  `nps_sn` mediumint(8) unsigned NOT NULL auto_increment,
  `title` varchar(255) NOT NULL default '',
  `head` text NOT NULL,
  `foot` text NOT NULL,
  `themes` varchar(255) NOT NULL default '',
  `status` enum('1','0') NOT NULL,
  PRIMARY KEY  (`nps_sn`)
) ENGINE=MyISAM;


CREATE TABLE `tad_news_sign` (
  `sign_sn` MEDIUMINT UNSIGNED NOT NULL auto_increment,
  `nsn` SMALLINT UNSIGNED NOT NULL ,
  `uid` SMALLINT UNSIGNED NOT NULL ,
  `sign_time` DATETIME NOT NULL,
  PRIMARY KEY  (`sign_sn`)
) ENGINE=MyISAM;

CREATE TABLE `tad_news_paper_send_log` (
  `npsn` smallint(5) unsigned NOT NULL,
  `email` varchar(255) NOT NULL default '',
  `send_time` datetime NOT NULL,
  `log` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`npsn`,`email`)
) ENGINE=MyISAM;
