<?php
/**
 * Ugm Wifi module
 *
 * You may not change or alter any portion of this comment or credits
 * of supporting developers from this source code or any supporting source code
 * which is considered copyrighted (c) material of the original comment or credit authors.
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * @copyright  The XOOPS Project http://sourceforge.net/projects/xoops/
 * @license    http://www.fsf.org/copyleft/gpl.html GNU public license
 * @package    Ugm Wifi
 * @since      2.5
 * @author     郭俊良
 * @version    $Id $
 **/

function xoops_module_install_ugm_wifi(&$module) {

	mk_dir(XOOPS_ROOT_PATH . "/uploads/ugm_wifi");
	mk_dir(XOOPS_ROOT_PATH . "/uploads/ugm_wifi/file");
	mk_dir(XOOPS_ROOT_PATH . "/uploads/ugm_wifi/image");
	mk_dir(XOOPS_ROOT_PATH . "/uploads/ugm_wifi/image/.thumbs");

	#更新資料表
	go_update();

	return true;
}
################################################################
#  更新
#  資料表->資料欄位
################################################################
function go_update() {
	//建立目錄
	#---------增加資料表------*/
	#---------增加欄位-------*/
	//----20161127
	$col = "account";
	$tbl = "ugm_wifi";
	$sql = "`account` varchar(255) NOT NULL default '' COMMENT 'WIFI帳號'";
	if (!chk_isColumn($col, $tbl)) {
		go_addColumn($tbl, $sql);
	}
	//種類
}

########################################
# 檢查某欄位是否存在(欄名,資料表)
########################################
function chk_isColumn($col_name = "", $tbl_name = "") {
	global $xoopsDB;
	if (!$col_name and $tbl_name) {
		return;
	}

	//SHOW COLUMNS FROM `show_kind` LIKE 'sn1'
	$sql = "SHOW COLUMNS FROM " . $xoopsDB->prefix($tbl_name) . " LIKE '{$col_name}'";
	$result = $xoopsDB->queryF($sql); //die($sql);
	if ($xoopsDB->getRowsNum($result)) {
		return true;
	}
	//欄位存在
	return false; //欄位不存在
}

function mk_dir($dir = "") {
	//若無目錄名稱秀出警告訊息
	if (empty($dir)) {
		return;
	}

	//若目錄不存在的話建立目錄
	if (!is_dir($dir)) {
		umask(000);
		//若建立失敗秀出警告訊息
		mkdir($dir, 0777);
	}
}

########################################
# 增加欄位
#  $tbl
#  $sql
########################################
function go_addColumn($tbl, $sql) {
	global $xoopsDB;
	$sql =
	"ALTER TABLE " . $xoopsDB->prefix($tbl) . "
   ADD
   {$sql}";
	$xoopsDB->queryF($sql);
}
